﻿#include "functions/copyObject.as"
load = function( saveIndex )
{
	EQUIP.unequip();
	// load RAM
	// // access saved data
	var srm = SharedObject.getLocal(ROM.misc.gameId);
	// // select save data
	var thisSlot = srm.data.slot[saveIndex];
	// // confirm save data
	if(thisSlot.saveInfo)
	{// if:  save data exists
		// delete current RAM
		var deleteAllData = function( thisObject ){
			for(var nam in thisObject){
				if(typeof(thisObject[nam]) == "object")
					deleteAllData( thisObject[nam] );		// delete contents
				thisObject[nam] = null;	delete thisObject[nam];		// delete variable
			}// for:  everything in this object
		}// deleteAllData()
		deleteAllData( RAM );
		_global.RAM = {};
		// // get data
		copyObject(thisSlot, RAM);
		
		// set initial stats and "equip" effects
		EQUIP.equip();
		
		// restore game state
		// // update save metadata
		RAM.saveInfo.loadTime = Number(getTimer());
		RAM.saveInfo.lastSaveIndex = saveIndex;
		// // restore audio settings
		if(RAM.audio.music.isPlaying){
			MUSIC.play( RAM.audio.music.songName );
		}else{
			MUSIC.songName = RAM.audio.music.songName;
			MUSIC.stop();
		}
		MUSIC.volume = RAM.audio.music.volume;
		MUSIC.songVolume = 100;
		SOUND.stopAll();
		SOUND.volume = RAM.audio.sound.volume;
		// // teleport
		var level = ROM.mapGrid[RAM.player.gridPosition.x][RAM.player.gridPosition.y].levelPath;
		var startPlace = {
			x:RAM.player.pixelPosition.x,
			y:RAM.player.pixelPosition.y
		}// mapCoords obj
		//ROOT.loadLevel( level, startPlace );
		LEVEL.onUnload();		// halt map updates until after the teleport
		ROOT.loadLevelTransition( level, startPlace, "transition_fade" );
		return true;
	}// if:  save data exists
	else{
		return false;
	}// if:  save data is missing / invalid
}// load()